
#ifndef LIGHT_CONTROL_ESP8266_BASE_STRUCTS_H
#define LIGHT_CONTROL_ESP8266_BASE_STRUCTS_H

#ifdef CCT_CONTROL
#define CCT_START_MIRED 1000000UL/CCT_START
#define CCT_END_MIRED 1000000UL/CCT_END
#endif

#ifdef INA_SENS
#define SENSORS
#endif


struct pin_state_str {
    int pin;
    bool state;
#ifdef PWM_CONTROL
    int pwm;
#endif
#ifdef PULSE_CONTROL
    int state_pin;
#endif
};

#ifdef IN_READER
struct in_pin_state_str {
    int pin;
    bool state;
#ifdef ADC
    unsigned level;
    unsigned max_level;
#endif
};
#endif

struct main_state_str {
    unsigned on_procents;
#ifdef CCT_CONTROL
    unsigned led_cct;
#endif
#ifdef WSRGB
    uint8_t rgb_r;
    uint8_t rgb_g;
    uint8_t rgb_b;
#endif
};

struct sensor_state_str
{
    const char *default_name;
    const char *device_class;
    const char *state_class;
    const char *unit_of_measurement;
    const bool diag;
    const bool hide;
    void *value;
    void *func;
};

#endif
