#ifdef PULSE_CONTROL
#ifdef INVERT_BUT_CONTROL
#define PULSE_ON OFF
#define PULSE_OFF ON
#else
#define PULSE_ON ON
#define PULSE_OFF OFF
#endif
#endif

void switch_io(int input, int out) {
    if (out < 0 || out >= PinsCount)
        return;
#ifdef PULSE_CONTROL
    if(input != pin_state[out].state){
        pinMode(pin_state[out].pin, OUTPUT);
        digitalWrite(pin_state[out].pin, PULSE_ON);
        delay(PULSE_TIME);
        digitalWrite(pin_state[out].pin, PULSE_OFF);
        pinMode(pin_state[out].pin, INPUT);
        pin_state[out].state = get_out_state(out);
    }
    debug_printf("sw pin: %d to %d", out, pin_state[out].state);
#else
    debug_printf("sw pin: %d to %d", out, input);
    if (input == 1) {
        set_out(out, ON);
    } else if (input == 0) {
        set_out(out, OFF);
    }
#endif
#if !defined(BRI_CONTROL) && !defined(CCT_CONTROL)
    send_io();
#endif
}

#ifdef PULSE_CONTROL
bool get_out_state(int out)
{
    if (digitalRead(pin_state[out].state_pin) == ON)
        return 1;
    else
        return 0;
}
#endif


bool set_out(size_t out, bool state) {
    if (out >= PinsCount)
        return false;
    pin_state[out].state = state;
#ifdef ESP8266
    digitalWrite(pin_state[out].pin, pin_state[out].state);
#elif defined(ESP32)
#ifdef PWM_CONTROL
    ledcWrite(pin_state[out].pin, pin_state[out].state);
#else
    digitalWrite(pin_state[out].pin, pin_state[out].state);
#endif
#endif
    pinStatesFile.update();
    debug_printf("set pin: %d to %d", pin_state[out].pin, pin_state[out].state);
    return true;
}

#ifdef PWM_CONTROL
bool set_out_pwm(size_t out, unsigned state)
{
  if (out >= PinsCount)
    return false;
  pin_state[out].pwm = state;
#ifdef ESP8266
  analogWrite(pin_state[out].pin, pin_state[out].pwm);
#elif defined(ESP32)
  ledcWrite(pin_state[out].pin, pin_state[out].pwm);
#endif
  if (state > 0)
    pin_state[out].state = ON;
  else
    pin_state[out].state = OFF;

  debug_printf("set pin: %d to %d pwm %d", pin_state[out].pin, pin_state[out].state, pin_state[out].pwm);
  pinStatesFile.update();
  return true;
}
#endif

bool get_once_state() {
    for (size_t i = 0; i < PinsCount; i++) {
        if (pin_state[i].state == ON)
            return true;
    }
    return false;
}

void set_all_out(bool state) {
    for (size_t i = 0; i < PinsCount; i++) {
        set_out(i, state);
    }
}

#ifdef CCT_CONTROL
bool set_out_cct(unsigned in)
{
  if (in < CCT_START || in > CCT_END)
    return false;
  main_state.led_cct = map(in, CCT_START, CCT_END, 0, PWM_MAX);
  debug_printf("led_cct: %u", main_state.on_procents);
  set_out_prc(200);
  mainStateFile.update();
  send_cct(main_state.led_cct);
  return true;
}
#endif

#if defined(BRI_CONTROL) || defined(CCT_CONTROL)
void set_out_prc(int in)
{
  bool restore_state = false;
  if (in < 0 || in > 100)
    restore_state = true;
#if defined(PWM_CONTROL) && defined(CCT_CONTROL) //PinsCount = 2
  int cw_pwm = 0, ww_pwm = 0;
  if (!restore_state) {
    main_state.on_procents = map(in, 0, 100, 0, PWM_MAX);
  }
  cw_pwm = main_state.led_cct;
  ww_pwm = PWM_MAX - main_state.led_cct;

  ww_pwm = ((float)ww_pwm / (float)PWM_MAX * (float)main_state.on_procents);
  cw_pwm = ((float)cw_pwm / (float)PWM_MAX * (float)main_state.on_procents);
  set_out_pwm(0, ww_pwm);
  set_out_pwm(1, cw_pwm);
#elif defined(PWM_CONTROL)
  if (!restore_state)
    main_state.on_procents = map(in, 0, 100, 0, PWM_MAX);
  for (size_t i = 0; i < PinsCount; i++)
  {
    set_out_pwm(i, main_state.on_procents);
  }
#else
  if (!restore_state) {
      main_state.on_procents = map(in, 0, 100, 0, PinsCount);
      if (main_state.on_procents == 0 && in != 0)
          main_state.on_procents = 1;
  }
  debug_printf("on_procents: %u", main_state.on_procents);
  for (size_t i = 0; i < PinsCount; i++)
  {
    if (main_state.on_procents <= i)
      set_out(i, OFF);
    else
      set_out(i, ON);
  }

#endif
  mainStateFile.update();
  send_prc(main_state.on_procents);
}

void set_power(bool power_state)
{
  if (!power_state)
    set_all_out(OFF);
  else if (power_state)
  {
    if (main_state.on_procents > 0)
      set_out_prc(200);
    else
      set_out_prc(100);
  }
  send_power();
}

bool switch_power()
{
    bool power_state = get_power();
    set_power(!power_state);
    return power_state;
}
#endif

bool get_power() {
    bool power_state = 0;

    for (size_t i = 0; i < PinsCount; i++) {
#ifdef PWM_CONTROL
        if(pin_state[i].pwm > 0 && pin_state[i].state != OFF)
            power_state = 1;
#else
        if (pin_state[i].state != OFF) {
            power_state = 1;
        }
#endif
    }
#ifdef WSRGB
    if (main_state.on_procents > 0)
        power_state = 1;
#endif
    return power_state;
}

#ifdef WSRGB
void set_rgb_color(uint8_t r, uint8_t g, uint8_t b) {
    main_state.rgb_r = r;
    main_state.rgb_g = g;
    main_state.rgb_b = b;
    
    // Apply current brightness
    uint8_t brightness = main_state.on_procents;
    uint8_t br = (r * brightness) / 255;
    uint8_t bg = (g * brightness) / 255;
    uint8_t bb = (b * brightness) / 255;
    
    for(int i=0; i<WS_NUM; i++) {
        ws_leds.setPixelColor(i, ws_leds.Color(br, bg, bb));
    }
    ws_leds.show();
    
    mainStateFile.update();
    debug_printf("set RGB color: %d, %d, %d (brightness: %d)", r, g, b, brightness);
    send_rgb_color();
}

void set_rgb_brightness(uint8_t brightness) {
    main_state.on_procents = brightness;
    
    // Apply to current color
    uint8_t r = (main_state.rgb_r * brightness) / 255;
    uint8_t g = (main_state.rgb_g * brightness) / 255;
    uint8_t b = (main_state.rgb_b * brightness) / 255;
    
    for(int i=0; i<WS_NUM; i++) {
        ws_leds.setPixelColor(i, ws_leds.Color(r, g, b));
    }
    ws_leds.show();
    
    mainStateFile.update();
    debug_printf("set RGB brightness: %d", brightness);
    send_rgb_brightness();
}

void set_rgb_power(bool power_state) {
    if (!power_state) {
        main_state.on_procents = 0;
        ws_leds.clear();
        ws_leds.show();
    } else {
        if (main_state.on_procents == 0) {
            main_state.on_procents = 255; // Full brightness
        }
        set_rgb_brightness(main_state.on_procents);
    }
    mainStateFile.update();
    debug_printf("set RGB power: %d", power_state);
    send_rgb_power();
    if (power_state) {
        send_rgb_brightness();
        send_rgb_color();
    }
}
#endif
