
// === Обработчики логики ===

void handle_status_message(const String& payloadStr) {
    debug_printf("pl: %s", payloadStr.c_str());
    if (payloadStr == "online") {
        send_config();
        send_sensor_config();
        send_all_state();
    }
}

void handle_io_command(const String& endTopic, int i_payload) {
    if (endTopic.length() > 0) {
        switch_io(i_payload, endTopic.toInt());
    }
}

#ifdef CCT_CONTROL
void handle_cct_control(int i_payload) {
    if (i_payload >= CCT_START && i_payload <= CCT_END) {
        set_out_cct(i_payload);
    }
}

void handle_cct_mired(int i_payload) {
    if (i_payload >= CCT_END_MIRED && i_payload <= CCT_START_MIRED) {
        unsigned long cct_new = (i_payload == CCT_START_MIRED) ? CCT_START :
                                (i_payload == CCT_END_MIRED) ? CCT_END :
                                1000000UL / i_payload;
        set_out_cct(cct_new);
    }
}
#endif

#if defined(BRI_CONTROL) || defined(CCT_CONTROL)
void handle_brightness_control(int i_payload) {
    if (i_payload >= 0 && i_payload <= 100) {
        set_out_prc(i_payload);
    }
}

void handle_power_command(int i_payload) {
    set_power(!!i_payload);
}
#endif

#ifdef WSRGB
void handle_rgb_brightness_control(int i_payload) {
    if (i_payload >= 0 && i_payload <= 255) {
        set_rgb_brightness(i_payload);
    }
}

void handle_rgb_power_command(int i_payload) {
    set_rgb_power(!!i_payload);
}

void handle_rgb_color_command(const String& payloadStr) {
    // Parse JSON color command: {"r":255,"g":128,"b":0}
    JsonDocument doc;
    DeserializationError error = deserializeJson(doc, payloadStr);
    
    if (!error) {
        if (doc.containsKey("r") && doc.containsKey("g") && doc.containsKey("b")) {
            uint8_t r = doc["r"];
            uint8_t g = doc["g"];
            uint8_t b = doc["b"];
            set_rgb_color(r, g, b);
        }
    }
}
#endif

void callback(char *topic, byte *payload, unsigned int length) {
    debug_printf("Message arrived [%s] ", topic);

#ifdef DEBUG
    for (unsigned int i = 0; i < length; i++) {
    Serial.print((char)payload[i]);
  }
  Serial.println();
#endif

    if (length == 0) return;

    String topicStr = String(topic);
    String payloadStr = String((char*)payload).substring(0, length);
    String cmdTopicStr = String(cmd_topic);

    if (topicStr == (topic_prefix + String("/status"))) {
        handle_status_message(payloadStr);
        return;
    }

    if (!topicStr.startsWith(cmdTopicStr + "/")) return;

    // Извлекаем под-топик
    String subTopic = topicStr.substring(cmdTopicStr.length() + 1);
    int slashIndex = subTopic.indexOf('/');
    String endTopic;

    if (slashIndex >= 0) {
        endTopic = subTopic.substring(slashIndex + 1);
        subTopic = subTopic.substring(0, slashIndex);
        if (endTopic.length() > 0) {
            debug_printf("end_topic: %s", endTopic.c_str());
        }
    }

    debug_printf("sub_topic: %s", subTopic.c_str());
    debug_printf("pl: %s", payloadStr.c_str());

    int i_payload = payloadStr.toInt();

    if (subTopic.equals(endpoint_type) && endTopic.length() > 0) {
        handle_io_command(endTopic, i_payload);
    } else if (subTopic == "update") {
        process_update();
    }

#ifdef CCT_CONTROL
    else if (subTopic == "cct") {
    handle_cct_control(i_payload);
  } else if (subTopic == "cct_mired") {
    handle_cct_mired(i_payload);
  }
#endif

#if defined(BRI_CONTROL) || defined(CCT_CONTROL)
    else if (subTopic.equals(endpoint_type)) {
    handle_brightness_control(i_payload);
  } else if (subTopic == String(endpoint_type) + "_power") {
    handle_power_command(i_payload);
  }
#endif

#ifdef WSRGB
    else if (subTopic == "rgb_brightness") {
    handle_rgb_brightness_control(i_payload);
  } else if (subTopic == "rgb_power") {
    handle_rgb_power_command(i_payload);
  } else if (subTopic == "rgb_color") {
    handle_rgb_color_command(payloadStr);
  }
#endif

    send_sensor_flag = true;
}



void reconnect() {
    // Loop until we're reconnected
    //debug_printf("Connected: %d, millis: %u, millis-priv: %u", client.connected(), millis(), (millis() - previousMillis));
    if(!client.connected() && (millis() - previousMillis >= RECONNECT_MQTT_INTERVAL || previousMillis == 0)) {
        debug_printf("Attempting MQTT connection...");
        // Attempt to connect
        if (client.connect(clientId.c_str(), mqtt_user, mqtt_password)) {
            debug_printf("connected");
            // Once connected, publish an announcement...
            send_all_state();
            send_config();
            send_sensor_config();
            client.subscribe(String(cmd_topic + "/#").c_str());
            client.subscribe(String(String(topic_prefix) + "/status").c_str());
        } else {
            debug_printf("failed, rc=%d try again", client.state());
        }
        previousMillis = millis();
    }
}

void send_status(String subtopic, String value) {
    String publish_topic = state_topic + "/" + subtopic;
    debug_printf("send state topic %s, value %s", publish_topic.c_str(), value.c_str());
    client.publish(publish_topic.c_str(), value.c_str(), true);
}
