struct sensor_state_str sensors_conf[] = {
#ifdef INA_SENS
  {.default_name = "device_vin", .device_class = "voltage", .state_class = "measurement", .unit_of_measurement = "V", .diag = true, .hide = false, .value = NULL, .func = NULL},
  {.default_name = "device_current", .device_class = "current", .state_class = "measurement", .unit_of_measurement = "A", .diag = true, .hide = false, .value = NULL, .func = NULL},
  {.default_name = "device_power", .device_class = "power", .state_class = "measurement", .unit_of_measurement = "W", .diag = true, .hide = false, .value = NULL, .func = NULL},
  {.default_name = "device_shunt_vin", .device_class = "voltage", .state_class = "measurement", .unit_of_measurement = "V", .diag = true, .hide = true, .value = NULL, .func = NULL},
  {.default_name = "device_current_calib", .device_class = NULL, .state_class = "measurement", .unit_of_measurement = NULL, .diag = true, .hide = true, .value = NULL, .func = NULL},
#endif

  {.default_name = "RSSI", .device_class = "signal_strength", .state_class = "measurement", .unit_of_measurement = "dBm", .diag = true, .hide = true, .value = NULL, .func = NULL},
  {.default_name = "free_heap", .device_class = "data_size", .state_class = "measurement", .unit_of_measurement = "B", .diag = true, .hide = true, .value = NULL, .func = NULL},
#ifdef SHARP_IR_GP2Y0A21YK0F
  {.default_name = "sharp_proximity_sensor", .device_class = "distance", .state_class = "measurement", .unit_of_measurement = "cm", .diag = true, .hide = false, .value = NULL, .func = NULL},
  {.default_name = "sharp_proximity_max", .device_class = "distance", .state_class = "measurement", .unit_of_measurement = "cm", .diag = true, .hide = true, .value = NULL, .func = NULL},
#endif
#ifdef POWER_DETECT_ESP8266_ADC
  {.default_name = "power_detect_adc", .device_class = NULL, .state_class = "measurement", .unit_of_measurement = NULL, .diag = true, .hide = true, .value = NULL, .func = NULL},
#endif
};

const size_t sensors_count = sizeof(sensors_conf) / sizeof(sensors_conf[0]);

void processing_all_sensors(bool every_loop) {
    if(every_loop == true) {
#ifdef SHARP_IR_GP2Y0A21YK0F
        *(float*)sensors_conf[get_sensor_index("sharp_proximity_sensor")].value = (proxy_sensor.getRawDistance(true) + *(float*)sensors_conf[get_sensor_index("sharp_proximity_sensor")].value)/2;
        if((*(float*)sensors_conf[get_sensor_index("sharp_proximity_max")].value - *(float*)sensors_conf[get_sensor_index("sharp_proximity_sensor")].value) > 60) {
            //debug_printf("sharp_proximity_sensor - sharp_proximity_max = %f", *(float*)sensors_conf[get_sensor_index("sharp_proximity_max")].value - *(float*)sensors_conf[get_sensor_index("sharp_proximity_sensor")].value);
            if(power_pressed_flag == false) {
                set_power(!get_power());
                power_pressed_timer = millis();
            }
            power_pressed_flag = true;
        }
        else if(power_pressed_flag && (millis() - power_pressed_timer >= POWER_SW_TIMEOUT)){
            power_pressed_flag = false;
        }
#endif

#ifdef POWER_DETECT_ESP8266_ADC
    *(unsigned*)sensors_conf[get_sensor_index("power_detect_adc")].value = system_adc_read();
    delay(5);
        if(*(unsigned*)sensors_conf[get_sensor_index("power_detect_adc")].value <= POWER_DETECT_ADC_TRIG_MIN && power_pressed_flag == false) {
                //debug_printf("vcc: %u", *(unsigned*)sensors_conf[get_sensor_index("power_detect_adc")].value);
                set_power(!get_power());

                pinStatesFile.updateNow();
#if defined(BRI_CONTROL) || defined(CCT_CONTROL)
                mainStateFile.updateNow();
#endif
                power_pressed_timer = millis();
                power_pressed_flag = true;
                client.disconnect();
        }
        else if(power_pressed_flag && millis() - power_pressed_timer >= POWER_DETECT_SW_TIMEOUT && *(unsigned*)sensors_conf[get_sensor_index("power_detect_adc")].value > POWER_DETECT_ADC_TRIG_MIN) {
                    power_pressed_flag = false;
                    reconnect();
        }
#endif

#ifdef PULSE_CONTROL
    for (size_t i = 0; i < PinsCount; i++) {
         if (get_out_state(i) != pin_state[i].state)
             {
                pin_state[i].state = get_out_state(i);
                send_io();
             }
    }
#endif
    }
    else {
#ifdef INA_SENS
        float current = ina.getCurrent();
        if(current > INA_MAX_CURRENT) {
          set_all_out(OFF);
        }
#endif
    }
}


void init_all_sensors() {
    for (size_t i = 0; i < sensors_count; i++)
    {
#ifdef POWER_DETECT_ESP8266_ADC
        if(i == get_sensor_index("power_detect_adc")) {
            sensors_conf[i].value = (void*)malloc(sizeof(unsigned));
            *(unsigned*)sensors_conf[i].value = 0;
            continue;
        }
#endif
        sensors_conf[i].value = (void*)malloc(sizeof(float));
        *(float*)sensors_conf[i].value = 0;
    }

#ifdef SHARP_IR_GP2Y0A21YK0F
    //proxy_sensor.setFilterRate(0.4f);
    *(float*)sensors_conf[get_sensor_index("sharp_proximity_sensor")].value = proxy_sensor.getRawDistance(true);
    if(*(float*)sensors_conf[get_sensor_index("sharp_proximity_sensor")].value > *(float*)sensors_conf[get_sensor_index("sharp_proximity_max")].value)
        *(float*)sensors_conf[get_sensor_index("sharp_proximity_max")].value = *(float*)sensors_conf[get_sensor_index("sharp_proximity_sensor")].value;
#endif
}

void send_all_sensors() {
  JsonDocument sensors;

#ifdef INA_SENS
  if (ina219_init_ok == true) {
    sensors[sensors_conf[get_sensor_index("device_vin")].default_name] = String(ina.getVoltage(), 2);
    sensors[sensors_conf[get_sensor_index("device_current")].default_name] = String(ina.getCurrent(), 2);
    sensors[sensors_conf[get_sensor_index("device_power")].default_name] = String(ina.getPower(), 2);
    sensors[sensors_conf[get_sensor_index("device_shunt_vin")].default_name] = ina.getShuntVoltage();
    sensors[sensors_conf[get_sensor_index("device_current_calib")].default_name] = ina.getCalibration();
  }
#endif
#ifdef SHARP_IR_GP2Y0A21YK0F
  if(*(float*)sensors_conf[get_sensor_index("sharp_proximity_sensor")].value > *(float*)sensors_conf[get_sensor_index("sharp_proximity_max")].value)
     *(float*)sensors_conf[get_sensor_index("sharp_proximity_max")].value = *(float*)sensors_conf[get_sensor_index("sharp_proximity_sensor")].value;

  //debug_printf("get_power() = %s", get_power() ? "true" : "false");
  //debug_printf("power_pressed_flag = %s", power_pressed_flag ? "true" : "false");
  //debug_printf("sharp_proximity_sensor - sharp_proximity_max = %f", (*(float*)sensors_conf[get_sensor_index("sharp_proximity_sensor")].value - *(float*)sensors_conf[get_sensor_index("sharp_proximity_max")].value));

  sensors[sensors_conf[get_sensor_index("sharp_proximity_sensor")].default_name] = String(*(float*)sensors_conf[get_sensor_index("sharp_proximity_sensor")].value, 2);
  sensors[sensors_conf[get_sensor_index("sharp_proximity_max")].default_name] = String(*(float*)sensors_conf[get_sensor_index("sharp_proximity_max")].value, 2);
#endif
#ifdef POWER_DETECT_ESP8266_ADC
  sensors[sensors_conf[get_sensor_index("power_detect_adc")].default_name] = *(unsigned*)sensors_conf[get_sensor_index("power_detect_adc")].value;
#endif
  sensors[sensors_conf[get_sensor_index("RSSI")].default_name] = WiFi.RSSI();
  sensors[sensors_conf[get_sensor_index("free_heap")].default_name] = ESP.getFreeHeap();

  String sensors_str;
  serializeJson(sensors, sensors_str);
  client.setBufferSize(sensors_str.length()+64);
  client.publish(String(device_sensor_topic + "/state").c_str(), sensors_str.c_str());
  client.setBufferSize(MQTT_MAX_PACKET_SIZE);

}

unsigned int get_sensor_index(const char *name)
{
    for (unsigned int i = 0; i < sensors_count; i ++)
    {
        if (strcmp(sensors_conf[i].default_name, name) == 0) {
            return i;
        }
    }
    return 0;
}
