// This file combines all .ino source files for testing
// It provides the necessary glue code and global definitions

#include "test_helpers.h"
#include "lamp_sources.h"

// Arduino built-in map function implementation
long map(long x, long in_min, long in_max, long out_min, long out_max) {
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

// External declarations for global variables (defined in test files)
extern size_t PinsCount;
extern pin_state_str pin_state[];
extern main_state_str main_state;
extern FileData<FSMock> pinStatesFile;
extern FileData<FSMock> mainStateFile;
extern WiFiClient espClient;
extern PubSubClient client;
extern WiFiUDP udp;
extern String device_topic;
extern String device_sensor_topic;
extern String cmd_topic;
extern String state_topic;
extern const char* dev_name;
extern const char* endpoint_type;
extern const char* topic_prefix;
extern const char* device_type;
extern vendor_info_str vendor_info;
extern sensor_state_str sensors_conf[];
extern size_t sensors_count;
extern volatile bool send_status_flag;
extern volatile bool send_sensor_flag;

// Additional missing globals
extern unsigned long previousMillis;
extern String clientId;
extern const char* mqtt_user;
extern const char* mqtt_password;

// Mock get_sta_mac function (weak symbol - can be overridden by tests)
__attribute__((weak)) String get_sta_mac() { 
    // Convert MAC address from "08:3A:8D:D1:BE:93" to "083A8DD1BE93"
    String mac = WiFi.macAddress();
    String result = "";
    for (unsigned int i = 0; i < mac.length(); i++) {
        if (mac[i] != ':') {
            result += mac[i];
        }
    }
    return result;
}

// Mock process_update function
void process_update() {}

// Mock ESP class for getFreeHeap
class ESPMock {
public:
    unsigned int getFreeHeap() { return 50000; }
} ESP;

#ifdef WSRGB
// NeoPixel library constants (from Adafruit_NeoPixel.h)
// These are required by main_logic.ino when compiled with WSRGB flag
#define NEO_GRB  ((1 << 6) | (1 << 4) | (0 << 2) | (2))
#define NEO_KHZ800 0x0000

// Mock Adafruit_NeoPixel class for test environment
// Real library is not available in test builds, so we provide stubs
class Adafruit_NeoPixel {
public:
    Adafruit_NeoPixel(int num, int pin, int type) : _numLeds(num) {}
    void begin() {}
    void show() {}
    void clear() {}
    void setPixelColor(int n, int r, int g, int b) {}
    void setPixelColor(int n, int c) {}
    void setBrightness(int bri) {}
    static int Color(int r, int g, int b) { return (r << 16) | (g << 8) | b; }
private:
    int _numLeds;
};

// Global ws_leds object used by main_logic.ino for RGB LED control
Adafruit_NeoPixel ws_leds(WS_NUM, WS_PIN, NEO_GRB + NEO_KHZ800);

// Forward declarations for WSRGB functions defined in utils.ino
void send_rgb_color();
void send_rgb_brightness();
void send_rgb_power();
#endif

// Include source files (except sens_logic which defines sensors_conf)
#include "../lamp_ctrl2_esp8266/main_logic.ino"
#include "../lamp_ctrl2_esp8266/utils.ino"
#include "../lamp_ctrl2_esp8266/mqtt_utils.ino"
// Note: sens_logic.ino is not included here because it defines sensors_conf[]
// which conflicts with test definitions. Functions from sens_logic need to be
// tested separately or redefined for tests.
