#ifndef LAMP_SOURCES_H
#define LAMP_SOURCES_H

#include "test_helpers.h"

// This header provides declarations for all functions from the .ino source files
// so they can be used in tests without code duplication

// From main_logic.ino
void switch_io(int input, int out);
bool set_out(size_t out, bool state);
bool set_out_pwm(size_t out, unsigned state);
bool get_once_state();
void set_all_out(bool state);
bool set_out_cct(unsigned in);
void set_out_prc(int in);
void set_power(bool power_state);
bool switch_power();
bool get_power();
#ifdef PULSE_CONTROL
bool get_out_state(int out);
#endif

// From utils.ino
size_t debug_printf(const char *format, ...);
void send_status_to_mqtt(const String &topic, const String &state);
void send_io();
void send_power();
void send_power(bool power_state);
void send_prc(unsigned on_procents);
void send_cct(unsigned led_cct);
void send_all_state();
void send_config();
void send_config(unsigned conf_id);
void send_device_info(JsonDocument &config);
void send_sensor_config();
void send_sensor_config(unsigned conf_id);
void status_send_f();
void sensors_send_f();

// From lamp_ctrl2_esp8266.ino
String get_sta_mac();

// From mqtt_utils.ino
void handle_status_message(const String& payloadStr);
void handle_io_command(const String& endTopic, int i_payload);
void handle_cct_control(int i_payload);
void handle_cct_mired(int i_payload);
void handle_brightness_control(int i_payload);
void handle_power_command(int i_payload);
void callback(char *topic, byte *payload, unsigned int length);
void reconnect();
void send_status(String subtopic, String value);

// From sens_logic.ino
void processing_all_sensors(bool every_loop);
void init_all_sensors();
void send_all_sensors();
unsigned int get_sensor_index(const char *name);

// Arduino built-in map function
long map(long x, long in_min, long in_max, long out_min, long out_max);

#endif // LAMP_SOURCES_H
