#ifndef FILEDATA_MOCK_H
#define FILEDATA_MOCK_H

#include "Arduino.h"

// FileData result status
typedef enum {
    FD_FS_ERR,
    FD_FILE_ERR,
    FD_WRITE,
    FD_ADD,
    FD_READ
} FDstat_t;

// Mock filesystem
class FSMock {
public:
    bool begin() { return true; }
    void format() {}
};

template<typename T>
class FileData {
public:
    FileData(T* fs, const char* path, char mode, void* data, size_t size) 
        : _fs(fs), _path(path), _mode(mode), _data(data), _size(size) {}
    
    FDstat_t read() {
        // Simulate reading from file (returns default values)
        return FD_READ;
    }
    
    void update() {
        _needsWrite = true;
    }
    
    void updateNow() {
        _needsWrite = false;
    }
    
    FDstat_t tick() {
        if (_needsWrite) {
            _needsWrite = false;
            return FD_WRITE;
        }
        return FD_READ;
    }
    
private:
    T* _fs;
    const char* _path;
    char _mode;
    void* _data;
    size_t _size;
    bool _needsWrite = false;
};

extern FSMock LittleFS;

#endif // FILEDATA_MOCK_H
