// Mock IRrecv.h for unit testing
// Provides minimal types needed by ir_control.ino

#ifndef IRRECV_H
#define IRRECV_H

#include <stdint.h>

// Protocol types - matches IRremoteESP8266
enum decode_type_t { 
    UNKNOWN = 0, 
    NEC = 1
};

// IR receive results structure - matches IRremoteESP8266
struct decode_results {
    decode_type_t decode_type;
    uint64_t value;
    uint16_t address;
    uint16_t command;
};

// Minimal IRrecv class stub
class IRrecv {
public:
    IRrecv(uint16_t recvpin, uint16_t bufsize = 100, uint8_t timeout = 15, bool save_buffer = false) {}
    void enableIRIn(bool pullup = false) {}
    void disableIRIn() {}
    bool decode(decode_results *results) { return false; }
    void resume() {}
};

#endif // IRRECV_H
