#ifndef TICKER_MOCK_H
#define TICKER_MOCK_H

#include <functional>

typedef std::function<void(void)> callback_function_t;

class Ticker {
public:
    void attach(float seconds, callback_function_t callback) {
        _callback = callback;
        _interval = (unsigned long)(seconds * 1000);
        _enabled = true;
    }
    
    void detach() {
        _enabled = false;
    }
    
    // For testing: manually trigger the callback
    void trigger() {
        if (_enabled && _callback) {
            _callback();
        }
    }
    
private:
    callback_function_t _callback;
    unsigned long _interval = 0;
    bool _enabled = false;
};

#endif // TICKER_MOCK_H
