#ifndef TEST_CONFIG_H
#define TEST_CONFIG_H

#include "test_helpers.h"

// Arduino built-in functions that need to be defined for the source files
long map(long x, long in_min, long in_max, long out_min, long out_max) {
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

// Mock debug_printf for non-DEBUG builds
#ifndef DEBUG
size_t debug_printf(const char *format, ...) {
    return 0;
}
#endif

// Global test variables that need to be defined before including source files
extern const size_t PinsCount;
extern pin_state_str pin_state[];
extern main_state_str main_state;
extern FileData<FSMock> pinStatesFile;
extern FileData<FSMock> mainStateFile;

// Mock globals for WiFi and MQTT
extern WiFiClient espClient;
extern PubSubClient client;
extern WiFiUDP udp;

// Topics
extern String device_topic;
extern String device_sensor_topic;
extern String cmd_topic;
extern String state_topic;

// Configuration constants
extern const char* dev_name;
extern const char* endpoint_type;
extern const char* topic_prefix;
extern const char* device_type;

// Vendor info
extern vendor_info_str vendor_info;

// Sensor configuration
extern sensor_state_str sensors_conf[];
extern const size_t sensors_count;

// Flags
extern volatile bool send_status_flag;
extern volatile bool send_sensor_flag;

#endif // TEST_CONFIG_H
