/**
 * Home Assistant Integration Tests - Main Entry Point
 * 
 * This file contains the global test variables and the main entry point
 * for all HA integration tests. The actual tests are split into separate
 * files based on device types for better readability:
 * 
 * - test_ha_light.cpp       - Light entity auto-discovery tests
 * - test_ha_sensor.cpp      - Sensor entity auto-discovery tests  
 * - test_ha_device_info.cpp - Device info validation tests
 * - test_ha_online_status.cpp - Online status and integration tests
 * - test_ha_config.cpp      - Hardware configuration parameterized tests
 */

#include "test_ha_common.h"

// ============================================================================
// Global Test Variables Definition
// ============================================================================

size_t PinsCount = 1;
pin_state_str pin_state[1] = {
    {.pin = D7, .state = OFF, .pwm = 0}
};

main_state_str main_state = {
    .on_procents = 0,
    .led_cct = 0
};

FileData<FSMock> pinStatesFile(&LittleFS, "/pinStates.dat", 'B', &pin_state, sizeof(pin_state));
FileData<FSMock> mainStateFile(&LittleFS, "/mainState.dat", 'B', &main_state, sizeof(main_state));

WiFiClient espClient;
PubSubClient client(espClient);
WiFiUDP udp;

String device_topic;
String device_sensor_topic;
String cmd_topic;
String state_topic;

const char* dev_name = "light-pulse";
const char* endpoint_type = "lamp";
const char* topic_prefix = "homeassistant";
const char* device_type = "light";

vendor_info_str vendor_info = {
    .manufacturer = "A1DEV",
    .model = "light control esp8266 lustra-relay",
    .hw_version = "0.2",
    .sw_version = "1.3 0aaac314",
    .support_url = "http://test.com"
};

sensor_state_str sensors_conf[] = {
    {.default_name = "RSSI", .device_class = "signal_strength", .state_class = "measurement", 
     .unit_of_measurement = "dBm", .diag = true, .hide = true, .value = NULL, .func = NULL}
};
size_t sensors_count = 1;

volatile bool send_status_flag = false;
volatile bool send_sensor_flag = false;

unsigned long previousMillis = 0;
String clientId = "test_client";
const char* mqtt_user = "test_user";
const char* mqtt_password = "test_password";

// ============================================================================
// Main Entry Point
// ============================================================================

int main(int argc, char **argv) {
    ::testing::InitGoogleTest(&argc, argv);
    return RUN_ALL_TESTS();
}
